/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class LordJyscalGuadoWatcher
extends Watcher {
    Set<UUID> set = new HashSet<UUID>();

    LordJyscalGuadoWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.COUNTER_ADDED) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game)) {
            this.set.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((LordJyscalGuadoWatcher)game.getState().getWatcher(LordJyscalGuadoWatcher.class)).set.contains(playerId);
    }
}

