/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LordWindgraceEffect
extends OneShotEffect {
    LordWindgraceEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard a card, then draw a card. If a land card is discarded this way, draw an additional card";
    }

    private LordWindgraceEffect(LordWindgraceEffect effect) {
        super((OneShotEffect)effect);
    }

    public LordWindgraceEffect copy() {
        return new LordWindgraceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discardOne(false, false, source, game);
        if (card == null || !card.isLand(game)) {
            player.drawCards(1, source, game);
        } else {
            player.drawCards(2, source, game);
        }
        return true;
    }
}

