/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.l.LotuslightDancersTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class LotuslightDancersEffect
extends OneShotEffect {
    LotuslightDancersEffect() {
        super(Outcome.Neutral);
        this.staticText = "search your library for a black card, a green card, and a blue card. Put those cards into your graveyard, then shuffle.";
    }

    private LotuslightDancersEffect(LotuslightDancersEffect effect) {
        super((OneShotEffect)effect);
    }

    public LotuslightDancersEffect copy() {
        return new LotuslightDancersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LotuslightDancersTarget target = new LotuslightDancersTarget();
        controller.searchLibrary((TargetCardInLibrary)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

