/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.assignment.common.ColorAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class LotuslightDancersTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a black card, a green card, and a blue card");
    private static final ColorAssignment colorAssigner;

    LotuslightDancersTarget() {
        super(0, 3, filter);
    }

    private LotuslightDancersTarget(LotuslightDancersTarget target) {
        super((TargetCardInLibrary)target);
    }

    public LotuslightDancersTarget copy() {
        return new LotuslightDancersTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return colorAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{new ColorPredicate(ObjectColor.BLUE), new ColorPredicate(ObjectColor.BLACK), new ColorPredicate(ObjectColor.GREEN)}));
        colorAssigner = new ColorAssignment(new String[]{"U", "B", "G"});
    }
}

