/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class LuciusTheEternalDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private MageObjectReference mor;

    LuciusTheEternalDelayedTriggeredAbility(Effect effect) {
        super(effect, Duration.WhileOnBattlefield, true);
        this.setTriggerPhrase("When that creature leaves the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    protected LuciusTheEternalDelayedTriggeredAbility(LuciusTheEternalDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public LuciusTheEternalDelayedTriggeredAbility copy() {
        return new LuciusTheEternalDelayedTriggeredAbility(this);
    }

    public void init(Game game) {
        this.mor = new MageObjectReference(this.getFirstTarget(), game);
        this.getTargets().clear();
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Permanent permanent = zEvent.getTarget();
        return Zone.BATTLEFIELD.equals((Object)zEvent.getFromZone()) && this.mor != null && this.mor.refersTo((MageObject)permanent, game);
    }
}

