/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.LukkaCoppercoatOutcastCastEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LukkaCoppercoatOutcastExileEffect
extends OneShotEffect {
    LukkaCoppercoatOutcastExileEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top three cards of your library. Creature cards exiled this way gain \"You may cast this card from exile as long as you control a Lukka planeswalker.\"";
    }

    private LukkaCoppercoatOutcastExileEffect(LukkaCoppercoatOutcastExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public LukkaCoppercoatOutcastExileEffect copy() {
        return new LukkaCoppercoatOutcastExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, 3);
        controller.moveCards(cards, Zone.EXILED, source, game);
        cards.stream().filter(card1 -> card1.isCreature(game)).forEach(card -> {
            LukkaCoppercoatOutcastCastEffect effect = new LukkaCoppercoatOutcastCastEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        });
        return true;
    }
}

