/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LukkaCoppercoatOutcastPolymorphEffect
extends OneShotEffect {
    LukkaCoppercoatOutcastPolymorphEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target creature you control, then reveal cards from the top of your library until you reveal a creature card with higher mana value. Put that card onto the battlefield and the rest on the bottom of your library in a random order.";
    }

    private LukkaCoppercoatOutcastPolymorphEffect(LukkaCoppercoatOutcastPolymorphEffect effect) {
        super((OneShotEffect)effect);
    }

    public LukkaCoppercoatOutcastPolymorphEffect copy() {
        return new LukkaCoppercoatOutcastPolymorphEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        int cmc = permanent.getManaValue();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        Card toBattlefield = null;
        CardsImpl toReveal = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (!card.isCreature(game) || card.getManaValue() <= cmc) continue;
            toBattlefield = card;
            break;
        }
        player.revealCards("", (Cards)toReveal, game);
        toReveal.remove(toBattlefield);
        player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
        player.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }
}

