/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTargetsPermanentCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.l.LullmagesDominationPredicate;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetadjustment.XManaValueTargetAdjuster;

public final class LullmagesDomination
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("a creature whose controller has eight or more cards in their graveyard");
    private static final Condition condition;

    public LullmagesDomination(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{X}{U}{U}{U}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(3, condition).setCanWorksOnStackOnly(true)).setRuleAtTheTop(true));
        this.getSpellAbility().addEffect((Effect)new GainControlTargetEffect(Duration.Custom).setText("gain control of target creature with mana value X"));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().setTargetAdjuster((TargetAdjuster)new XManaValueTargetAdjuster());
    }

    private LullmagesDomination(LullmagesDomination card) {
        super((CardImpl)card);
    }

    public LullmagesDomination copy() {
        return new LullmagesDomination(this);
    }

    static {
        filter.add((Predicate)LullmagesDominationPredicate.instance);
        condition = new SourceTargetsPermanentCondition(filter);
    }
}

