/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.l.LuluSternGuardianPredicate;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class LuluSternGuardianTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature attacking you");

    LuluSternGuardianTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.STUN.createInstance()).setText("choose target creature attacking you. Put a stun counter on that creature"));
        this.setTriggerPhrase("Whenever an opponent attacks you, ");
        this.addTarget((Target)new TargetPermanent(filter));
    }

    private LuluSternGuardianTriggeredAbility(LuluSternGuardianTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LuluSternGuardianTriggeredAbility copy() {
        return new LuluSternGuardianTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DEFENDER_ATTACKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return this.isControlledBy(event.getTargetId()) && game.getOpponents(this.getControllerId()).contains(event.getPlayerId());
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)LuluSternGuardianPredicate.instance);
    }
}

