/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class LumberingBattlementEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("other nontoken creatures");

    LumberingBattlementEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of other nontoken creatures you control until it leaves the battlefield";
    }

    private LumberingBattlementEffect(LumberingBattlementEffect effect) {
        super((OneShotEffect)effect);
    }

    public LumberingBattlementEffect copy() {
        return new LumberingBattlementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePerm = source.getSourcePermanentIfItStillExists(game);
        if (player == null || sourcePerm == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        if (!player.choose(Outcome.Neutral, (Target)target, source, game)) {
            return false;
        }
        HashSet<Permanent> cards = new HashSet<Permanent>();
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            cards.add(permanent);
        }
        player.moveCardsToExile(cards, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourcePerm.getIdName());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

