/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.players.Player;

class LuminousBroodmothEffect
extends OneShotEffect {
    LuminousBroodmothEffect() {
        super(Outcome.PutCardInPlay);
    }

    private LuminousBroodmothEffect(LuminousBroodmothEffect effect) {
        super((OneShotEffect)effect);
    }

    public LuminousBroodmothEffect copy() {
        return new LuminousBroodmothEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        Player player = game.getPlayer(card.getOwnerId());
        if (player == null) {
            return false;
        }
        Counters countersToAdd = new Counters(new Counter[0]);
        countersToAdd.addCounter(CounterType.FLYING.createInstance());
        game.setEnterWithCounters(card.getId(), countersToAdd);
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

