/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.l.LuminousBroodmothEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LuminousBroodmothTriggeredAbility
extends TriggeredAbilityImpl {
    LuminousBroodmothTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LuminousBroodmothEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private LuminousBroodmothTriggeredAbility(LuminousBroodmothTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LuminousBroodmothTriggeredAbility copy() {
        return new LuminousBroodmothTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTarget() == null || zEvent.getTarget().getId().equals(this.getSourceId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(zEvent.getTarget().getId());
        if (permanent != null && zEvent.isDiesEvent() && permanent.isCreature(game) && !permanent.getAbilities().containsKey(FlyingAbility.getInstance().getId()) && permanent.isControlledBy(this.controllerId)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(zEvent.getTargetId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control without flying dies, return it to the battlefield under its owner's control with a flying counter on it.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

