/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.ObjectColor;
import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LureboundScarecrowTriggeredAbility
extends StateTriggeredAbility {
    private static final String staticText = "When you control no permanents of the chosen color, sacrifice {this}.";

    public LureboundScarecrowTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
    }

    private LureboundScarecrowTriggeredAbility(LureboundScarecrowTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ObjectColor color;
        Permanent permanent = game.getPermanent(this.getSourceId());
        if (permanent != null && (color = (ObjectColor)game.getState().getValue(this.getSourceId() + "_color")) != null) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents(this.controllerId)) {
                if (!perm.getColor(game).contains(color)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LureboundScarecrowTriggeredAbility copy() {
        return new LureboundScarecrowTriggeredAbility(this);
    }

    public String getRule() {
        return staticText;
    }
}

