/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LuxiorGiadasGiftEffect
extends ContinuousEffectImpl {
    LuxiorGiadasGiftEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "equipped permanent isn't a planeswalker and is a creature in addition to its other types";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private LuxiorGiadasGiftEffect(LuxiorGiadasGiftEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LuxiorGiadasGiftEffect copy() {
        return new LuxiorGiadasGiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> {
            permanent.removeCardType(game, new CardType[]{CardType.PLANESWALKER});
            permanent.removeAllSubTypes(game, SubTypeSet.PlaneswalkerType);
            permanent.addCardType(game, new CardType[]{CardType.CREATURE});
        });
        return true;
    }
}

