/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;

class LydiaFryeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.ASSASSIN);
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    LydiaFryeEffect() {
        super(Outcome.Benefit);
        this.staticText = "surveil X, where X is the number of tapped Assassins you control";
    }

    private LydiaFryeEffect(LydiaFryeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LydiaFryeEffect copy() {
        return new LydiaFryeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int count = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        return player != null && count > 0 && player.surveil(count, source, game);
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
        hint = new ValueHint("Tapped Assassins you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

