/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.watchers.common.PermanentWasCastWatcher;

class ContainmentPriestReplacementEffect
extends ReplacementEffectImpl {
    ContainmentPriestReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "until end of turn, if a nontoken creature would enter the battlefield and it wasn't cast, exile it instead";
    }

    private ContainmentPriestReplacementEffect(ContainmentPriestReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ContainmentPriestReplacementEffect copy() {
        return new ContainmentPriestReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(event.getTargetId());
            if (card != null) {
                controller.moveCardsToExile(card, source, game, true, null, null);
            }
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        if (((ZoneChangeEvent)event).getToZone() == Zone.BATTLEFIELD && (card = game.getCard(event.getTargetId())) != null) {
            Object entersTransformed = game.getState().getValue("EnterTransformed" + event.getTargetId());
            if (entersTransformed instanceof Boolean && ((Boolean)entersTransformed).booleanValue() && card.getSecondCardFace() != null) {
                card = card.getSecondCardFace();
            }
            if (card != null && card.isCreature(game)) {
                PermanentWasCastWatcher watcher = (PermanentWasCastWatcher)game.getState().getWatcher(PermanentWasCastWatcher.class);
                return watcher != null && !watcher.wasPermanentCastThisTurn(event.getTargetId());
            }
        }
        return false;
    }
}

