/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.ObjectColor;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class LastSpellCastWatcher
extends Watcher {
    private ObjectColor lastSpellColor = null;

    public LastSpellCastWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            MageObject mageObject;
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell == null && (mageObject = game.getLastKnownInformation(event.getTargetId(), Zone.STACK)) instanceof Spell) {
                spell = (Spell)mageObject;
            }
            if (spell != null) {
                this.lastSpellColor = spell.getColor(game);
            }
        }
    }

    public void reset() {
        super.reset();
        this.lastSpellColor = null;
    }

    public ObjectColor getLastSpellColor() {
        return this.lastSpellColor;
    }
}

