/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MadcapExperimentEffect
extends OneShotEffect {
    MadcapExperimentEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reveal cards from the top of your library until you reveal an artifact card. Put that card onto the battlefield and the rest on the bottom of your library in a random order. {this} deals damage to you equal to the number of cards revealed this way";
    }

    private MadcapExperimentEffect(MadcapExperimentEffect effect) {
        super((OneShotEffect)effect);
    }

    public MadcapExperimentEffect copy() {
        return new MadcapExperimentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl toReveal = new CardsImpl();
            Card toBattlefield = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                game.fireUpdatePlayersEvent();
                if (!card.isArtifact(game)) continue;
                toBattlefield = card;
                break;
            }
            controller.revealCards(source, (Cards)toReveal, game);
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
            int damage = toReveal.size();
            toReveal.remove(toBattlefield);
            controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
            controller.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

