/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.FightTargetsEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.m.MageDuelCondition;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class MageDuel
extends CardImpl {
    private static final Hint hint = new ConditionHint((Condition)MageDuelCondition.instance, "You've cast an instant or sorcery this turn");

    public MageDuel(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{G}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2, (Condition)MageDuelCondition.instance).setCanWorksOnStackOnly(true)).setRuleAtTheTop(true).addHint(hint));
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 2));
        this.getSpellAbility().addEffect((Effect)new FightTargetsEffect().setText("Then it fights target creature you don't control. <i>(Each deals damage equal to its power to the other.)</i>"));
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent());
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
    }

    private MageDuel(MageDuel card) {
        super((CardImpl)card);
    }

    public MageDuel copy() {
        return new MageDuel(this);
    }
}

