/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.watchers.common.SpellsCastWatcher;

enum MageDuelCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher == null) {
            return false;
        }
        List spells = watcher.getSpellsCastThisTurn(source.getControllerId());
        return spells != null && spells.stream().filter(Objects::nonNull).filter(spell -> spell.isInstantOrSorcery(game)).anyMatch(spell -> !spell.getSourceId().equals(source.getSourceId()));
    }

    public String toString() {
        return "you've cast another instant or sorcery spell this turn";
    }
}

