/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MageHunterTriggeredAbility
extends TriggeredAbilityImpl {
    MageHunterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1), false);
    }

    private MageHunterTriggeredAbility(MageHunterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COPIED_STACKOBJECT || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !game.getOpponents(this.getControllerId()).contains(spell.getControllerId()) || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(spell.getControllerId()));
        return true;
    }

    public String getRule() {
        return "Whenever an opponent casts or copies an instant or sorcery spell, they lose 1 life.";
    }

    public MageHunterTriggeredAbility copy() {
        return new MageHunterTriggeredAbility(this);
    }
}

