/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MageHuntersOnslaughtDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    MageHuntersOnslaughtDelayedTriggeredAbility() {
        super((Effect)new LoseLifeTargetEffect(1), Duration.EndOfTurn, false, false);
    }

    private MageHuntersOnslaughtDelayedTriggeredAbility(MageHuntersOnslaughtDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATURE_BLOCKS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
        return true;
    }

    public MageHuntersOnslaughtDelayedTriggeredAbility copy() {
        return new MageHuntersOnslaughtDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature blocks this turn, its controller loses 1 life.";
    }
}

