/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedCounterRemovedValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventDamageAndRemoveCountersEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class MagmaPummelerPreventionEffect
extends PreventDamageAndRemoveCountersEffect {
    private UUID reflexiveId;

    MagmaPummelerPreventionEffect() {
        super(true, true, true);
        this.staticText = "If damage would be dealt to {this} while it has a +1/+1 counter on it, prevent that damage and remove that many +1/+1 counters from it. When one or more counters are removed from {this} this way, it deals that much damage to any target.";
        this.reflexiveId = null;
    }

    private MagmaPummelerPreventionEffect(MagmaPummelerPreventionEffect effect) {
        super((PreventDamageAndRemoveCountersEffect)effect);
        this.reflexiveId = effect.reflexiveId;
    }

    public PreventDamageAndRemoveCountersEffect copy() {
        return new MagmaPummelerPreventionEffect(this);
    }

    protected void onDamagePrevented(GameEvent event, Ability source, Game game, int amountRemovedInTotal, int amountRemovedThisTime) {
        ReflexiveTriggeredAbility reflexive;
        super.onDamagePrevented(event, source, game, amountRemovedInTotal, amountRemovedThisTime);
        if (amountRemovedInTotal == amountRemovedThisTime && amountRemovedInTotal > 0) {
            reflexive = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect((DynamicValue)SavedCounterRemovedValue.MUCH), false, "When one or more counters are removed from {this} this way, it deals that much damage to any target.");
            reflexive.addTarget((Target)new TargetAnyTarget());
            this.reflexiveId = game.fireReflexiveTriggeredAbility(reflexive, source, true);
        }
        if (this.reflexiveId != null) {
            reflexive = game.getState().getDelayed().get(this.reflexiveId).orElse(null);
            if (reflexive instanceof ReflexiveTriggeredAbility) {
                reflexive.getEffects().setValue("CounterRemoved", (Object)amountRemovedInTotal);
            } else {
                this.reflexiveId = null;
            }
        }
    }
}

