/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPermanentsEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

class MagmaticGalleonTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    MagmaticGalleonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new TreasureToken()));
        this.setTriggerPhrase("Whenever one or more creatures your opponents control are dealt excess noncombat damage, ");
    }

    private MagmaticGalleonTriggeredAbility(MagmaticGalleonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MagmaticGalleonTriggeredAbility copy() {
        return new MagmaticGalleonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PERMANENTS;
    }

    public boolean checkEvent(DamagedPermanentEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return permanent != null && permanent.isCreature(game) && game.getOpponents(this.getControllerId()).contains(permanent.getControllerId()) && !event.isCombatDamage();
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int damage = this.getFilteredEvents((BatchEvent)((DamagedBatchForPermanentsEvent)event), game).stream().mapToInt(DamagedEvent::getExcess).sum();
        return damage >= 1;
    }
}

