/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MagnanimousMagistrateEffect
extends OneShotEffect {
    MagnanimousMagistrateEffect() {
        super(Outcome.Benefit);
        this.staticText = "if its mana value was 1 or greater, you may remove that many reprieve counters from {this}. If you do, return that card to the battlefield under its owner's control";
    }

    private MagnanimousMagistrateEffect(MagnanimousMagistrateEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagnanimousMagistrateEffect copy() {
        return new MagnanimousMagistrateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = (Permanent)this.getValue("creatureDied");
        if (player == null || sourcePermanent == null || creature == null || sourcePermanent.getCounters(game).getCount(CounterType.REPRIEVE) < creature.getManaValue() || game.getState().getZoneChangeCounter(creature.getId()) != creature.getZoneChangeCounter(game) + 1 || !player.chooseUse(this.outcome, "Remove " + creature.getManaValue() + " reprieve counters from " + sourcePermanent.getName() + '?', source, game)) {
            return false;
        }
        sourcePermanent.removeCounters(CounterType.REPRIEVE.createInstance(creature.getManaValue()), source, game);
        player.moveCards(game.getCard(creature.getId()), Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

