/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ForestwalkAbility;
import mage.abilities.keyword.IslandwalkAbility;
import mage.abilities.keyword.MountainwalkAbility;
import mage.abilities.keyword.PlainswalkAbility;
import mage.abilities.keyword.SwampwalkAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MagnigothTreefolkEffect
extends ContinuousEffectImpl {
    MagnigothTreefolkEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "for each basic land type among lands you control, {this} has landwalk of that type";
    }

    private MagnigothTreefolkEffect(MagnigothTreefolkEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MagnigothTreefolkEffect copy() {
        return new MagnigothTreefolkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        List landTypes = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LANDS, source.getControllerId(), source, game).stream().map(p -> SubType.getBasicLands().stream().filter(subType -> p.hasSubtype(subType, game)).collect(Collectors.toSet())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        if (landTypes.isEmpty()) {
            return false;
        }
        for (SubType subType : landTypes) {
            switch (subType) {
                case PLAINS: {
                    permanent.addAbility((Ability)new PlainswalkAbility(), source.getSourceId(), game);
                    break;
                }
                case ISLAND: {
                    permanent.addAbility((Ability)new IslandwalkAbility(), source.getSourceId(), game);
                    break;
                }
                case SWAMP: {
                    permanent.addAbility((Ability)new SwampwalkAbility(), source.getSourceId(), game);
                    break;
                }
                case MOUNTAIN: {
                    permanent.addAbility((Ability)new MountainwalkAbility(), source.getSourceId(), game);
                    break;
                }
                case FOREST: {
                    permanent.addAbility((Ability)new ForestwalkAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }
}

