/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.util.CardUtil;

class MagnusTheRedEffect
extends CostModificationEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();
    private static final DynamicValue xValue;
    private static final Hint hint;

    MagnusTheRedEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "instant and sorcery spells you cast cost {1} less to cast for each creature token you control";
    }

    private MagnusTheRedEffect(MagnusTheRedEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)xValue.calculate(game, source, (Effect)this));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && ((SpellAbility)abilityToModify).getCharacteristics(game).isInstantOrSorcery(game) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public MagnusTheRedEffect copy() {
        return new MagnusTheRedEffect(this);
    }

    public static Hint getHint() {
        return hint;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Creature tokens you control", xValue);
    }
}

