/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MagusOfTheBridgeTriggeredAbility
extends TriggeredAbilityImpl {
    public MagusOfTheBridgeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileSourceEffect());
        this.setTriggerPhrase("When a creature is put into an opponent's graveyard from the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MagusOfTheBridgeTriggeredAbility(MagusOfTheBridgeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MagusOfTheBridgeTriggeredAbility copy() {
        return new MagusOfTheBridgeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent()) {
            Permanent permanent = zEvent.getTarget();
            Player controller = game.getPlayer(this.getControllerId());
            return permanent != null && controller != null && permanent.isCreature(game) && controller.hasOpponent(permanent.getOwnerId(), game);
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

