/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class MakeAnExampleEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creatures to put in the first pile");

    public MakeAnExampleEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each opponent separates the creatures they control into two piles. For each opponent, you choose one of their piles. Each opponent sacrifices the creatures in their chosen pile";
    }

    private MakeAnExampleEffect(MakeAnExampleEffect effect) {
        super((OneShotEffect)effect);
    }

    public MakeAnExampleEffect copy() {
        return new MakeAnExampleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        ArrayList toSacrifice = new ArrayList();
        for (UUID opponentId : game.getOpponents(controllerId)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
            opponent.choose(Outcome.Sacrifice, (Target)target, source, game);
            List chosenTargets = target.getTargets();
            ArrayList<Permanent> pile1 = new ArrayList<Permanent>();
            ArrayList<Permanent> pile2 = new ArrayList<Permanent>();
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, opponentId, game)) {
                if (chosenTargets.contains(permanent.getId())) {
                    pile1.add(permanent);
                    continue;
                }
                pile2.add(permanent);
            }
            if (controller.choosePile(Outcome.Sacrifice, "Choose a pile for " + opponent.getName() + " to sacrifice", pile1, pile2, game)) {
                toSacrifice.addAll(pile1);
                continue;
            }
            toSacrifice.addAll(pile2);
        }
        for (Permanent permanent : toSacrifice) {
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

