/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MalanthropeEffect
extends OneShotEffect {
    MalanthropeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target player's graveyard. Put a +1/+1 counter on {this} for each creature card exiled this way";
    }

    private MalanthropeEffect(MalanthropeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MalanthropeEffect copy() {
        return new MalanthropeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || player.getGraveyard().isEmpty()) {
            return false;
        }
        int count = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        player.moveCards((Cards)player.getGraveyard(), Zone.EXILED, source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null && count > 0) {
            game.processAction();
            permanent.addCounters(CounterType.P1P1.createInstance(count), source, game);
        }
        return true;
    }
}

