/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class MalcatorPurityOverseerWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    MalcatorPurityOverseerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && ((EntersTheBattlefieldEvent)event).getTarget().isArtifact(game)) {
            this.map.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        return ((MalcatorPurityOverseerWatcher)game.getState().getWatcher(MalcatorPurityOverseerWatcher.class)).map.getOrDefault(source.getControllerId(), 0) >= 3;
    }

    static int getCount(Ability source, Game game) {
        return ((MalcatorPurityOverseerWatcher)game.getState().getWatcher(MalcatorPurityOverseerWatcher.class)).map.getOrDefault(source.getControllerId(), 0);
    }
}

