/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class MalevolentWitchkiteEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("artifacts, enchantments, and/or tokens");

    MalevolentWitchkiteEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of artifacts, enchantments, and/or tokens, then draw that many cards";
    }

    private MalevolentWitchkiteEffect(MalevolentWitchkiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public MalevolentWitchkiteEffect copy() {
        return new MalevolentWitchkiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        controller.choose(Outcome.Sacrifice, (Target)target, source, game);
        List toSacrifice = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        int sacrificeCount = 0;
        if (!toSacrifice.isEmpty()) {
            sacrificeCount = toSacrifice.size();
            game.informPlayers(controller.getLogName() + " chose " + sacrificeCount + " permanents to sacrifice. " + CardUtil.getSourceLogName((Game)game, (Ability)source));
            new SacrificeTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(toSacrifice, game)).apply(game, source);
        }
        new DrawCardSourceControllerEffect(sacrificeCount).apply(game, source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.ENCHANTMENT.getPredicate(), TokenPredicate.TRUE}));
    }
}

