/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MalignantGrowthEffect
extends OneShotEffect {
    MalignantGrowthEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player draws an additional card for each growth counter on {this}, then {this} deals damage to the player equal to the number of cards they drew this way.";
    }

    private MalignantGrowthEffect(MalignantGrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public MalignantGrowthEffect copy() {
        return new MalignantGrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        int counters = permanent.getCounters(game).getCount(CounterType.GROWTH);
        if (counters == 0) {
            return true;
        }
        return player.damage(player.drawCards(counters, source, game), source.getSourceId(), source, game) > 0;
    }
}

