/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfMainPhaseDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.AddManaToManaPoolTargetControllerEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ManaDrainCounterEffect
extends OneShotEffect {
    ManaDrainCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. At the beginning of your next main phase, add an amount of {C} equal to that spell's mana value";
    }

    private ManaDrainCounterEffect(ManaDrainCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaDrainCounterEffect copy() {
        return new ManaDrainCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
            int cmc = spell.getManaValue();
            AddManaToManaPoolTargetControllerEffect effect = new AddManaToManaPoolTargetControllerEffect(Mana.ColorlessMana((int)cmc), "your");
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getControllerId()));
            AtTheBeginOfMainPhaseDelayedTriggeredAbility delayedAbility = new AtTheBeginOfMainPhaseDelayedTriggeredAbility((Effect)effect, false, TargetController.YOU, AtTheBeginOfMainPhaseDelayedTriggeredAbility.PhaseSelection.NEXT_MAIN);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

