/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.m.LastSpellCastWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class ManaMazeEffect
extends ContinuousRuleModifyingEffectImpl {
    ManaMazeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't cast spells that share a color with the spell most recently cast this turn";
    }

    private ManaMazeEffect(ManaMazeEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        LastSpellCastWatcher watcher;
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
        if (spellAbility == null) {
            return false;
        }
        Card card = spellAbility.getCharacteristics(game);
        if (card != null && (watcher = (LastSpellCastWatcher)game.getState().getWatcher(LastSpellCastWatcher.class)) != null && watcher.getLastSpellColor() != null) {
            return !card.getColor(game).intersection(watcher.getLastSpellColor()).isColorless();
        }
        return false;
    }

    public ManaMazeEffect copy() {
        return new ManaMazeEffect(this);
    }
}

