/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.util.CardUtil;

class ManaReflectionReplacementEffect
extends ReplacementEffectImpl {
    ManaReflectionReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you tap a permanent for mana, it produces twice as much of that mana instead";
    }

    private ManaReflectionReplacementEffect(ManaReflectionReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Mana mana = ((ManaEvent)event).getMana();
        if (mana.getBlack() > 0) {
            mana.set(ManaType.BLACK, CardUtil.overflowMultiply((int)mana.getBlack(), (int)2));
        }
        if (mana.getBlue() > 0) {
            mana.set(ManaType.BLUE, CardUtil.overflowMultiply((int)mana.getBlue(), (int)2));
        }
        if (mana.getWhite() > 0) {
            mana.set(ManaType.WHITE, CardUtil.overflowMultiply((int)mana.getWhite(), (int)2));
        }
        if (mana.getGreen() > 0) {
            mana.set(ManaType.GREEN, CardUtil.overflowMultiply((int)mana.getGreen(), (int)2));
        }
        if (mana.getRed() > 0) {
            mana.set(ManaType.RED, CardUtil.overflowMultiply((int)mana.getRed(), (int)2));
        }
        if (mana.getColorless() > 0) {
            mana.set(ManaType.COLORLESS, CardUtil.overflowMultiply((int)mana.getColorless(), (int)2));
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public ManaReflectionReplacementEffect copy() {
        return new ManaReflectionReplacementEffect(this);
    }
}

