/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collections;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.mana.AnyColorLandsProduceManaAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ManaWebeffect
extends OneShotEffect {
    ManaWebeffect() {
        super(Outcome.Tap);
    }

    private ManaWebeffect(ManaWebeffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaWebeffect copy() {
        return new ManaWebeffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("tappedPermanent");
        if (permanent == null) {
            return false;
        }
        Set manaTypesSource = AnyColorLandsProduceManaAbility.getManaTypesFromPermanent((Permanent)permanent, (Game)game);
        boolean tappedLands = false;
        for (Permanent opponentPermanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, permanent.getControllerId(), source, game)) {
            Set manaTypes = AnyColorLandsProduceManaAbility.getManaTypesFromPermanent((Permanent)opponentPermanent, (Game)game);
            if (Collections.disjoint(manaTypes, manaTypesSource)) continue;
            opponentPermanent.tap(source, game);
        }
        return tappedLands;
    }
}

