/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.stack.Spell;

class MandateOfPeaceEndCombatEffect
extends OneShotEffect {
    MandateOfPeaceEndCombatEffect() {
        super(Outcome.Benefit);
        this.staticText = "End the combat phase. <i>(Remove all attackers and blockers from combat. Exile all spells and abilities from the stack, including this spell.)</i>";
    }

    private MandateOfPeaceEndCombatEffect(MandateOfPeaceEndCombatEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Combat combat = game.getCombat();
        Set attackerIds = combat.getAttackers();
        Set blockerIds = combat.getBlockers();
        Stream.concat(blockerIds.stream(), attackerIds.stream()).map(id -> game.getPermanent(id)).filter(e -> e != null).forEach(permanent -> permanent.removeFromCombat(game));
        combat.endCombat(game);
        if (!game.getStack().isEmpty()) {
            game.getStack().stream().filter(Spell.class::isInstance).forEach(stackObject -> ((Spell)stackObject).moveToExile(null, "", null, game));
            game.getStack().stream().filter(Ability.class::isInstance).forEach(stackObject -> game.getStack().remove(stackObject, game));
        }
        return true;
    }

    public MandateOfPeaceEndCombatEffect copy() {
        return new MandateOfPeaceEndCombatEffect(this);
    }
}

