/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MarathWillOfTheWildRemoveCountersCost
extends CostImpl {
    MarathWillOfTheWildRemoveCountersCost() {
        this.text = "Remove X +1/+1 counters from Marath";
    }

    private MarathWillOfTheWildRemoveCountersCost(MarathWillOfTheWildRemoveCountersCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.P1P1) > 0;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        int amount = GetXValue.instance.calculate(game, ability, null);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.getCounters(game).getCount(CounterType.P1P1) >= amount) {
            permanent.removeCounters(CounterType.P1P1.getName(), amount, source, game);
            this.paid = true;
        }
        return this.paid;
    }

    public MarathWillOfTheWildRemoveCountersCost copy() {
        return new MarathWillOfTheWildRemoveCountersCost(this);
    }
}

