/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class MarchOfBurgeoningLifeEffect
extends OneShotEffect {
    MarchOfBurgeoningLifeEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature with mana value less than X. Search your library for a creature card with the same name as that creature, put it onto the battlefield tapped, then shuffle";
    }

    private MarchOfBurgeoningLifeEffect(MarchOfBurgeoningLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarchOfBurgeoningLifeEffect copy() {
        return new MarchOfBurgeoningLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card with the same name as " + permanent.getName());
        filter.add((Predicate)new MarchOfBurgeoningLifePredicate(permanent));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)filter);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    private static class MarchOfBurgeoningLifePredicate
    implements Predicate<Card> {
        private final Permanent permanent;

        private MarchOfBurgeoningLifePredicate(Permanent permanent) {
            this.permanent = permanent;
        }

        public boolean apply(Card input, Game game) {
            return CardUtil.haveSameNames((MageObject)this.permanent, (MageObject)input);
        }
    }
}

