/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveCounterCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.m.MariTheKillingQuillDrawAndTokenEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.CastFromZonePredicate;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;

class MariTheKillingQuillDealsDamageEffect
extends OneShotEffect {
    MariTheKillingQuillDealsDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may remove a hit counter from a card that player owns in exile. If you do, draw a card and create two Treasure tokens.";
    }

    private MariTheKillingQuillDealsDamageEffect(MariTheKillingQuillDealsDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        FilterCard filterCard = new FilterCard("a card that player owns in exile");
        filterCard.add((Predicate)new OwnerIdPredicate(opponent.getId()));
        filterCard.add(Predicates.not((Predicate)FaceDownPredicate.instance));
        filterCard.add((Predicate)new CastFromZonePredicate(Zone.EXILED));
        DoIfCostPaid doIfCostPaidEffect = new DoIfCostPaid((Effect)new MariTheKillingQuillDrawAndTokenEffect(), (Cost)new RemoveCounterCost((Target)new TargetCard(Zone.EXILED, filterCard)));
        return doIfCostPaidEffect.apply(game, source);
    }

    public MariTheKillingQuillDealsDamageEffect copy() {
        return new MariTheKillingQuillDealsDamageEffect(this);
    }
}

