/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MarkOfEvictionEffect
extends OneShotEffect {
    MarkOfEvictionEffect() {
        super(Outcome.Benefit);
        this.staticText = "return enchanted creature and all Auras attached to that creature to their owners' hands";
    }

    private MarkOfEvictionEffect(MarkOfEvictionEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarkOfEvictionEffect copy() {
        return new MarkOfEvictionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchanted;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourceObject != null && sourceObject.getAttachedTo() != null && (enchanted = game.getPermanent(sourceObject.getAttachedTo())) != null) {
            HashSet<Permanent> toHand = new HashSet<Permanent>();
            toHand.add(enchanted);
            for (UUID attachmentId : enchanted.getAttachments()) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (attachment == null || !attachment.hasSubtype(SubType.AURA, game)) continue;
                toHand.add(attachment);
            }
            controller.moveCards(toHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

