/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.common.TargetAnyTarget;

class MartyrdomRedirectDamageTargetEffect
extends RedirectionEffect {
    private static FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public MartyrdomRedirectDamageTargetEffect(Duration duration, int amount) {
        super(duration, amount, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next " + amount + " damage that would be dealt to target creature, planeswalker, or player this turn is dealt to {this} instead";
    }

    private MartyrdomRedirectDamageTargetEffect(MartyrdomRedirectDamageTargetEffect effect) {
        super((RedirectionEffect)effect);
    }

    public MartyrdomRedirectDamageTargetEffect copy() {
        return new MartyrdomRedirectDamageTargetEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && filter.match(permanent, permanent.getControllerId(), source, game) && event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && event.getTargetId() != null) {
            TargetAnyTarget target = new TargetAnyTarget();
            target.add(source.getSourceId(), game);
            this.redirectTarget = target;
            return true;
        }
        return false;
    }
}

