/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ConniveSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MaskOfTheSchemerEffect
extends OneShotEffect {
    MaskOfTheSchemerEffect() {
        super(Outcome.Benefit);
        this.staticText = "it connives X, where X is the amount of damage it dealt to that player. <i>(Draw X card, then discard X cards. Put a +1/+1 counter on that creature for each nonland card discarded this way.)</i>";
    }

    private MaskOfTheSchemerEffect(MaskOfTheSchemerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaskOfTheSchemerEffect copy() {
        return new MaskOfTheSchemerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = source.getSourcePermanentOrLKI(game);
        int damage = (Integer)this.getValue("damage");
        if (equipment == null || damage < 1) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        return ConniveSourceEffect.connive((Permanent)permanent, (int)damage, (Ability)source, (Game)game);
    }
}

