/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MasterOfCrueltiesEffect;
import mage.cards.m.MasterOfCrueltiesNoDamageEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MasterOfCrueltiesTriggeredAbility
extends TriggeredAbilityImpl {
    public MasterOfCrueltiesTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MasterOfCrueltiesEffect());
        this.addEffect((Effect)new MasterOfCrueltiesNoDamageEffect());
        this.setTriggerPhrase("Whenever {this} attacks a player and isn't blocked, ");
    }

    private MasterOfCrueltiesTriggeredAbility(MasterOfCrueltiesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MasterOfCrueltiesTriggeredAbility copy() {
        return new MasterOfCrueltiesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_BLOCKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        if (sourcePermanent.isAttacking()) {
            for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                Player defendingPlayer;
                if (!combatGroup.getBlockers().isEmpty() || !combatGroup.getAttackers().contains(this.getSourceId()) || (defendingPlayer = game.getPlayer(combatGroup.getDefenderId())) == null) continue;
                return true;
            }
        }
        return false;
    }
}

