/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.abilities.effects.RequirementEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleTargetEffect;
import mage.abilities.effects.common.combat.CantAttackTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.ControlCombatRedundancyWatcher;

class MasterWarcraftChooseAttackersEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures that will attack this combat (creatures not chosen won't attack this combat)");

    MasterWarcraftChooseAttackersEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, false, false);
        this.staticText = "You choose which creatures attack this turn";
    }

    private MasterWarcraftChooseAttackersEffect(MasterWarcraftChooseAttackersEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public MasterWarcraftChooseAttackersEffect copy() {
        return new MasterWarcraftChooseAttackersEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARING_ATTACKERS;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        ControlCombatRedundancyWatcher.addAttackingController((UUID)source.getControllerId(), (Duration)this.duration, (Game)game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!ControlCombatRedundancyWatcher.checkAttackingController((UUID)source.getControllerId(), (Game)game)) {
            game.informPlayers(source.getSourceObject(game).getIdName() + " didn't apply");
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Player attackingPlayer = game.getPlayer(game.getCombat().getAttackingPlayerId());
        if (controller == null || attackingPlayer == null || attackingPlayer.getAvailableAttackers(game).isEmpty()) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
        if (!controller.chooseTarget(Outcome.Benefit, (Target)target, source, game)) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterCreaturePermanent(), source.getControllerId(), source, game)) {
            if (target.getTargets().contains(permanent.getId())) {
                AttacksIfAbleTargetEffect effect = new AttacksIfAbleTargetEffect(Duration.EndOfCombat);
                effect.setText("");
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
                game.informPlayers(controller.getLogName() + " has decided that " + permanent.getLogName() + " attacks this combat if able");
                continue;
            }
            boolean hasToAttack = false;
            for (Map.Entry entry : game.getContinuousEffects().getApplicableRequirementEffects(permanent, false, game).entrySet()) {
                RequirementEffect effect2 = (RequirementEffect)entry.getKey();
                if (!effect2.mustAttack(game)) continue;
                hasToAttack = true;
            }
            if (hasToAttack) continue;
            CantAttackTargetEffect effect = new CantAttackTargetEffect(Duration.EndOfCombat);
            effect.setText("");
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.ACTIVE.getControllerPredicate());
    }
}

