/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MegatronDestructiveForceReflexiveEffect
extends OneShotEffect {
    private final int value;

    MegatronDestructiveForceReflexiveEffect(int value) {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage equal to the sacrificed artifact's mana value to target creature. If excess damage would be dealt to that creature this way, instead that damage is dealt to that creature's controller and you convert {this}.";
        this.value = value;
    }

    private MegatronDestructiveForceReflexiveEffect(MegatronDestructiveForceReflexiveEffect effect) {
        super((OneShotEffect)effect);
        this.value = effect.value;
    }

    public MegatronDestructiveForceReflexiveEffect copy() {
        return new MegatronDestructiveForceReflexiveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (this.value < 1) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(this.value, source, game);
        if (excess < 1) {
            return true;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.damage(excess, source, game);
        }
        new TransformSourceEffect().apply(game, source);
        return true;
    }
}

