/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;

class MegatronTyrantCantCastSpellsEffect
extends ContinuousRuleModifyingEffectImpl {
    MegatronTyrantCantCastSpellsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Your opponents can't cast spells during combat.";
    }

    private MegatronTyrantCantCastSpellsEffect(MegatronTyrantCantCastSpellsEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public MegatronTyrantCantCastSpellsEffect copy() {
        return new MegatronTyrantCantCastSpellsEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast spells during combat (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getOpponents(source.getControllerId()).contains(event.getPlayerId()) && game.getTurnPhaseType() == TurnPhase.COMBAT;
    }
}

