/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.CastOnlyDuringPhaseStepSourceAbility;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.BeforeBlockersAreDeclaredCondition;
import mage.abilities.condition.common.IsPhaseCondition;
import mage.abilities.condition.common.MyTurnCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.combat.ChooseBlockersEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.m.MeleeTriggeredAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.watchers.Watcher;
import mage.watchers.common.ControlCombatRedundancyWatcher;

public final class Melee
extends CardImpl {
    private static final Condition condition = new CompoundCondition(new Condition[]{BeforeBlockersAreDeclaredCondition.instance, new IsPhaseCondition(TurnPhase.COMBAT), MyTurnCondition.instance});
    private static final Hint hint = new ConditionHint(condition, "Can be cast");

    public Melee(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{4}{R}");
        this.addAbility(new CastOnlyDuringPhaseStepSourceAbility(null, null, condition, "Cast this spell only during combat on your turn before blockers are declared").addHint(hint));
        this.getSpellAbility().addEffect((Effect)new ChooseBlockersEffect(Duration.EndOfCombat));
        this.getSpellAbility().addWatcher((Watcher)new ControlCombatRedundancyWatcher());
        this.getSpellAbility().addEffect((Effect)new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new MeleeTriggeredAbility()).concatBy("<br>"));
    }

    private Melee(Melee card) {
        super((CardImpl)card);
    }

    public Melee copy() {
        return new Melee(this);
    }
}

