/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.m.MeliraTheLivingCurePreventionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class MeliraTheLivingCureReplacementEffect
extends ReplacementEffectImpl {
    MeliraTheLivingCureReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would get one or more poison counters, instead you get one poison counter and you can't get additional poison counters this turn";
    }

    private MeliraTheLivingCureReplacementEffect(MeliraTheLivingCureReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(1);
        game.addEffect((ContinuousEffect)new MeliraTheLivingCurePreventionEffect(), source);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getTargetId()) && CounterType.POISON.getName().equals(event.getData()) && event.getAmount() > 0;
    }

    public MeliraTheLivingCureReplacementEffect copy() {
        return new MeliraTheLivingCureReplacementEffect(this);
    }
}

